/* LAME PLUGIN FOR WAVECUT */

/*********************************************** SETUP *******/

/* full path with drive to lame.exe */
lameprg = "D:\apps\sound\lame\lame.exe"

/* bitrate (32 40 48 56 64 80 96 112 128 160 192 224 256 320)*/
bitrate="128"

/* priority (0 1 2 3 4; 0=idle, 4 = max priority */
priority = "0"

/* quality/speed (f=fast and low, h=slower but higher quality*/
quality = "h"

/* mode ((s)tereo, (j)oint, (m)ono, (a)uto*/
mode = "j"



/*********************************************** START *******/
parse arg working_dir
say; say "encode2mp3.cmd v.01"
say "Encodes all wav-files in " working_dir
say " to mp3-files."
say
/* search for wav files*/
rc = SysFileTree(working_dir||'*.wav','wavstem',"FO","*----")
if wavstem.0 > 0 then
 do i = 1 to wavstem.0
  mp3_file = substr(wavstem.i, 1, length(wavstem.i)-4)||'.mp3'
  command = lameprg "-b"||bitrate "-"||quality "--priority" priority "-m"||mode wavstem.i mp3_file
  address cmd command
  say "Deleting file:" wavstem.i "..."
   rc = SysFileDelete(wavstem.i)
  say "...done."
 end
beep(1000,200);beep(800,200)
exit

